<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use  PDO;

use Illuminate\Support\Facades\Validator;
use App\Models\User;
use Illuminate\Validation\Rules;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{ 
    public function getUserProfile($id)
    {

        $user = User::find($id);

        return response()->json(['user' => $user],200);
    }

    public function updateUserProfile(Request $request,$id)
    {
        $user = User::find($id);


           $user->first_name = $request->input('first_name'); 
           $user->last_name = $request->input('last_name'); 
           $user->username =  $request->input('first_name').' '. $request->input('last_name');
           $user->title = $request->input('title'); 
           $user->address_1 = $request->input('address_1');
           $user->address_2 = $request->input('address_2');
           $user->city = $request->input('city');  
           $user->state = $request->input('state');  
           $user->state1 = $request->input('state1');  
           $user->country_id = $request->input('country_id'); 
           $user->postal_code = $request->input('postal_code'); 
           $user->phone_number = $request->input('phone_number'); 
           $user->email = $request->input('email');

           $user->save();

           return response()->json(['Sucsess' => 'updated'],200);
    }

    public function deleteUserProfile($id)
    {

        $user = User::find($id);

        $user->delete();

        return response()->json(['Success' => 'Deleted'],200);
    }

    public function changePassword(Request $request,$id)
    {
        $user = User::find($id);

        $request->validate([
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        if(Hash::check($request->input('old_password'),$user->password))
        {
            $user->password = Hash::make($request->input('password'));

            $user->save();

            return response()->json(['Success' => 'Password Changed'],200);
        }
        else
        {
            return response()->json(['error' => 'password not match'],403);
        }

    }
}